const controller = new ScrollMagic.Controller({ loglevel: 0 });

const GAP_PX = 50;
const nav = document.querySelector('.navigation-container');
const circle = document.querySelector('.main-video-container');

// UI, которое уменьшаем/прячем на 50% круга
const uiToFadeSelectors = ['.hero-left', '.hero-right', '.play-toggle', '.scroll-indicator'];

function placeLinksRightOfCircle() {
  if (!nav || !circle) return;
  const r = circle.getBoundingClientRect();
  const targetLeft = Math.round(r.right + GAP_PX);
  nav.style.left = `${targetLeft}px`;
}

// Стартовые состояния
gsap.set('.main-video-container', { opacity: 1, height: '100vh' });
gsap.set(nav, { opacity: 0, x: 200 }); // старт: скрыты и смещены вправо
gsap.set('.video-main', { pointerEvents: 'auto' });
gsap.set(uiToFadeSelectors, {
  transformOrigin: '50% 50%',
  scale: 1,
  autoAlpha: 1
});
// гарантируем кликабельность на старте
gsap.set(['.play-toggle', '.scroll-indicator'], { pointerEvents: 'auto' });

// === СЦЕНА 1: сжатие круга + исчезновение UI к 50% ===
const tlStage1 = gsap.timeline();
tlStage1
  // 100vh -> 50vh
  .to('.main-video-container', { height: '50vh', ease: "power2.in" }, 0)
  // параллельно уменьшаем/бледним UI
  .to(uiToFadeSelectors, { scale: 0.85, autoAlpha: 0.6, ease: "power1.out" }, 0)
  // к моменту ~50% — полностью скрываем
  .to(uiToFadeSelectors, { scale: 0.7, autoAlpha: 0, ease: "power1.out" }, 0.48)
  // затем 50vh -> 260px
  .to('.main-video-container', { height: '260px', ease: "power2.in" });

const scene1 = new ScrollMagic.Scene({
  triggerElement: "#stage-1",
  duration: "80%",
  triggerHook: 0
})
.setTween(tlStage1)
.addTo(controller);

// ВОЗВРАТ pointer-events при прокрутке вверх (< 0.5 прогресса)
scene1.on('progress', (e) => {
  const active = e.progress < 0.5; // пока круг > 50%
  gsap.set(['.play-toggle', '.scroll-indicator', '.hero-left', '.hero-right'], {
    pointerEvents: active ? 'auto' : 'none'
  });
});

// === СЦЕНА 2: смещение круга влево + ссылки "выезжают справа" и проявляются ===
new ScrollMagic.Scene({
  triggerElement: "#stage-2",
  duration: "100%",
  triggerHook: 0
})
.setTween(
  gsap.timeline({
      // во время всей сцены держим ссылки на расстоянии 50px от круга
      onUpdate: placeLinksRightOfCircle
    })
    // круг начинает уходить влево
    .to('.main-video-container', { left: 'calc(-0.01vw + 130px)', ease: "power3.out" }, 0)
    // одновременно блок ссылок едет справа к своей позиции и проявляется 0% -> 100%
    .fromTo(nav,
      { x: 200, autoAlpha: 0 },
      { x: 0, autoAlpha: 1, duration: 0.6, ease: "power2.out" },
      0 // старт одновременно с началом движения круга
    )
)
.addTo(controller);

// === СЦЕНА 3: уводим круг и НЕ трогаем позицию ссылок (без фиксации к краю) ===
new ScrollMagic.Scene({
  triggerElement: "#stage-3",
  duration: "150%",
  triggerHook: 0
})
.setTween(
  gsap.timeline()
    .to('.main-video-container', {
      left: '-10px',
      opacity: 0,
      ease: "power1.out"
    })
    // ссылки остаются на месте — без дополнительных твинов
)
.addTo(controller);

// === СЦЕНА 4: появление малого логотипа ===
new ScrollMagic.Scene({
  triggerElement: "#stage-4",
  duration: "100%",
  triggerHook: 0
})
.setTween(gsap.timeline().to('.video-logo', { y: -10, opacity: 1, ease: "power1.inOut" }))
.addTo(controller);

window.addEventListener('resize', placeLinksRightOfCircle);
