(function () {
  const mq = window.matchMedia('(max-width: 768px)');

  function closeAll(except) {
    document.querySelectorAll('.item-wrap.is-open').forEach((el) => {
      if (!except || el !== except) el.classList.remove('is-open');
    });
  }

  document.querySelectorAll('.item-wrap').forEach((wrap) => {
    wrap.addEventListener(
      'click',
      (e) => {
        // На десктопе ничего не делаем: работает hover как раньше
        if (!mq.matches) return;

        const openBtn = e.target.closest('.card-more');
        const closeBtn = e.target.closest('.card-close');

        // Если клик по кнопкам — не даём <a href="#"> прыгать наверх
        if (openBtn || closeBtn) e.preventDefault();

        if (openBtn) {
          closeAll(wrap);
          wrap.classList.add('is-open');
          return;
        }

        if (closeBtn) {
          wrap.classList.remove('is-open');
        }
      },
      { passive: false }
    );
  });

  // Тап вне карточек — закрыть
  document.addEventListener('click', (e) => {
    if (!mq.matches) return;
    if (!e.target.closest('.item-wrap')) closeAll();
  });

  // При смене брейкпоинта/ориентации — закрыть всё
  if (mq.addEventListener) {
    mq.addEventListener('change', () => closeAll());
  } else if (mq.addListener) {
    mq.addListener(() => closeAll());
  }
})();
