/** Calculate Slides total price (Embedded-safe)
 *  Usage:
 *    <script src="js/config.js"></script>
 *    <script src="js/prices.js"></script>
 *    // after slides injected:
 *    window.initPrices('#embedded-test');
 */

let slidesSteps = {};
let defaultSlideId = '';

function __pricesStorageKey() {
  try {
    if (typeof window.currentIdKey === 'function') return window.currentIdKey() + '-state';
  } catch (e) {}
  return 'embedded-test-state';
}

const getPriceSteps = (slideId) => Object.keys(slidesPrices?.[slideId] || {});
const totalPrice = (slideId) => {
  const steps = getPriceSteps(slideId);
  let price = 0;

  $.each(steps, (idx, key) => {
    if (slidesSteps?.[slideId]?.[key] > 0) {
      price += slidesPrices[slideId][key];
    }
  });

  return price;
};

const resetPriceSteps = (root, slideId) => {
  const steps = getPriceSteps(slideId);

  if (typeof slidesSteps[slideId] === 'undefined') slidesSteps[slideId] = {};

  $.each(steps, (idx, key) => {
    slidesSteps[slideId][key] = 0;
    root.find('#' + slideId + ' .' + key).removeClass('active');
  });

  root.find('#' + slideId + ' .totalPrice').text(totalPrice(slideId));
  stateSave({ slideId, steps: slidesSteps });
};

const addPriceListeners = (root, slideId) => {
  const steps = getPriceSteps(slideId);
  if (!steps.length) return;

  if (typeof slidesSteps[slideId] === 'undefined') slidesSteps[slideId] = {};

  steps.forEach((key) => {
    root.find('.' + slideId + '-' + key).off('click.__prices').on('click.__prices', (event) => {
      event.preventDefault();

      slidesSteps[slideId][key] = 1;
      root.find('#' + slideId + ' .' + key).addClass('active');

      const total = totalPrice(slideId);
      root.find('#' + slideId + ' .totalPrice').text(total);

      if (total > 0) {
        if (slideId === 'slide6d7' && total > 12000) {
          const firstHalf = total - 12000;
          root.find('#slide6d7-fh').html(firstHalf);
        }
        root.find('.' + slideId + '-Total').css('display', 'inline-block');
      }

      stateSave({ slideId, steps: slidesSteps });
    });

    const removeKey = key.replace('addStep', 'removeStep');

    root.find('.' + slideId + '-' + removeKey).off('click.__prices').on('click.__prices', (event) => {
      event.preventDefault();

      slidesSteps[slideId][key] = 0;
      root.find('#' + slideId + ' .' + key).removeClass('active');

      const total = totalPrice(slideId);
      root.find('#' + slideId + ' .totalPrice').text(total);

      if (total === 0) {
        root.find('.' + slideId + '-Total').css('display', 'none');
      }

      stateSave({ slideId, steps: slidesSteps });
    });
  });

  root.find('.' + slideId + '-resetSteps').off('click.__prices').on('click.__prices', (event) => {
    event.preventDefault();
    resetPriceSteps(root, slideId);
  });
};

const stateSave = (state) => {
  sessionStorage.setItem(__pricesStorageKey(), JSON.stringify(state || {}));
};

const stateLoad = () => sessionStorage.getItem(__pricesStorageKey());

const stateRestore = (root, state) => {
  if (!state) return;

  let st;
  try {
    st = JSON.parse(state);
  } catch (e) {
    return;
  }

  const slideId = (typeof st.slideId !== 'undefined') ? st.slideId : defaultSlideId;
  if (typeof st.steps !== 'undefined') slidesSteps = st.steps;

  const steps = getPriceSteps(slideId);

  steps.forEach((key) => {
    const active = slidesSteps?.[slideId]?.[key] > 0;
    root.find('#' + slideId + ' .' + key).toggleClass('active', !!active);
  });

  const total = totalPrice(slideId);
  root.find('#' + slideId + ' .totalPrice').text(total);

  if (total > 0) {
    root.find('.' + slideId + '-Total').show();
  }
};

const getSlidesSteps = () => {
  const steps = jQuery.extend(true, {}, slidesPrices || {});
  $.each(steps, (slideId) => {
    const st = steps[slideId];
    $.each(st, (k) => {
      steps[slideId][k] = 0;
    });
  });
  return steps;
};

function initPrices(rootSelector) {
  const root = $(rootSelector || document);

  if (typeof window.slidesPrices === 'undefined') {
    console.warn('[prices.js] slidesPrices not found. Did you load config.js before prices.js?');
    return;
  }

  slidesSteps = getSlidesSteps();
  defaultSlideId = Object.keys(slidesSteps)[0] || '';

  const prices = Object.keys(slidesPrices);
  if (!prices.length) return;

  prices.forEach((slideId) => {
    root.find('.' + slideId + '-Total').hide();
  });

  const st = stateLoad();
  if (st) stateRestore(root, st);

  prices.forEach((slideId) => {
    addPriceListeners(root, slideId);
  });
}

window.initPrices = initPrices;
