/* ============================================================
   SCROLLMAGIC + GSAP АНИМАЦИИ
   Desktop и Mobile версии полностью независимы
   ============================================================ */

const controller = new ScrollMagic.Controller({ loglevel: 0 });

// Всё, что ≤ 420 px — мобильная версия
const mq = window.matchMedia('(max-width: 420px)');

/* ---------- Общие элементы ---------- */
const GAP_PX = 50;
const nav = document.querySelector('.navigation-container');
const circle = document.querySelector('.main-video-container');

/* ---------- Desktop helper: позиционирование ссылок справа от круга ---------- */
function placeLinksRightOfCircle() {
  if (!nav || !circle) return;
  const r = circle.getBoundingClientRect();
  const targetLeft = Math.round(r.right + GAP_PX);
  nav.style.left = `${targetLeft}px`;
}

/* ============================================================
   MOBILE — без скролла, анимация при загрузке
   ============================================================ */
function initMobile() {
  console.log('Mobile version active (≤420px)');

  // Отключаем прокрутку
  document.body.style.overflow = 'hidden';
  window.scrollTo(0, 0);

  // Гарантируем, что всё видно
  gsap.set(['.hero-left', '.hero-right'], { autoAlpha: 1, display: 'block' });
  gsap.set('.video-logo', { autoAlpha: 0, display: 'none' });
  if (nav) gsap.set(nav, { autoAlpha: 1, display: 'flex' });

  // Появление ссылок — одна за другой
  const items = document.querySelectorAll('.navigation-item');
  if (items.length > 0) {
    gsap.set(items, { y: 50, autoAlpha: 0 });
    gsap.delayedCall(0.5, () => {
      gsap.to(items, {
        y: 0,
        autoAlpha: 1,
        duration: 0.7,
        ease: 'power3.out',
        stagger: 0.5
      });
    });
  }

  // Перестраховка: при попытке скролла возвращаем страницу вверх
  window.addEventListener('scroll', () => {
    window.scrollTo(0, 0);
  });
}

/* ============================================================
   DESKTOP / TABLET — оригинальная анимация GSAP + ScrollMagic
   ============================================================ */
function initDesktop() {
  console.log('Desktop/Tablet version active (>420px)');

  const uiToFadeSelectors = ['.hero-left', '.hero-right', '.play-toggle', '.scroll-indicator'];

  // Стартовые состояния
  gsap.set('.main-video-container', { opacity: 1, height: '100vh' });
  gsap.set(nav, { opacity: 0, x: 200 });
  gsap.set('.video-main', { pointerEvents: 'auto' });
  gsap.set(uiToFadeSelectors, { transformOrigin: '50% 50%', scale: 1, autoAlpha: 1 });
  gsap.set(['.play-toggle', '.scroll-indicator'], { pointerEvents: 'auto' });

  // ---------- СЦЕНА 1 ----------
  const tlStage1 = gsap.timeline()
    .to('.main-video-container', { height: '50vh', ease: "power2.in" }, 0)
    .to(uiToFadeSelectors, { scale: 0.85, autoAlpha: 0.6, ease: "power1.out" }, 0)
    .to(uiToFadeSelectors, { scale: 0.7, autoAlpha: 0, ease: "power1.out" }, 0.48)
    .to('.main-video-container', { height: '260px', ease: "power2.in" });

  const scene1 = new ScrollMagic.Scene({
    triggerElement: "#stage-1",
    duration: "80%",
    triggerHook: 0
  })
    .setTween(tlStage1)
    .addTo(controller);

  scene1.on('progress', (e) => {
    const active = e.progress < 0.5;
    gsap.set(['.play-toggle', '.scroll-indicator', '.hero-left', '.hero-right'], {
      pointerEvents: active ? 'auto' : 'none'
    });
  });

  // ---------- СЦЕНА 2 ----------
  new ScrollMagic.Scene({
    triggerElement: "#stage-2",
    duration: "100%",
    triggerHook: 0
  })
    .setTween(
      gsap.timeline({ onUpdate: placeLinksRightOfCircle })
        .to('.main-video-container', { left: 'calc(-0.01vw + 130px)', ease: "power3.out" }, 0)
        .fromTo(nav, { x: 200, autoAlpha: 0 }, { x: 0, autoAlpha: 1, duration: 0.6, ease: "power2.out" }, 0)
    )
    .addTo(controller);

  // ---------- СЦЕНА 3 ----------
  new ScrollMagic.Scene({
    triggerElement: "#stage-3",
    duration: "150%",
    triggerHook: 0
  })
    .setTween(
      gsap.timeline().to('.main-video-container', { left: '-10px', opacity: 0, ease: "power1.out" })
    )
    .addTo(controller);

  // ---------- СЦЕНА 4 ----------
  new ScrollMagic.Scene({
    triggerElement: "#stage-4",
    duration: "100%",
    triggerHook: 0
  })
    .setTween(
      gsap.timeline().to('.video-logo', { y: -10, opacity: 1, ease: "power1.inOut" })
    )
    .addTo(controller);

  window.addEventListener('resize', placeLinksRightOfCircle);
}

/* ============================================================
   Инициализация
   ============================================================ */
function boot() { mq.matches ? initMobile() : initDesktop(); }
boot();
mq.addEventListener('change', () => location.reload());
