/**
 * redirect.js
 * Автоматически корректирует пути к HTML-страницам портфолио,
 * чтобы они открывались из подпапки /portfolio_pages/,
 * сохраняя прежнюю логику всплывающих окон (glightbox).
 * Работа выполняется по договору.
 */

document.addEventListener('DOMContentLoaded', () => {
  const links = document.querySelectorAll('.portfolio-details-lightbox');

  links.forEach(link => {
    const href = link.getAttribute('href');

    // если ссылка указывает на html-файл, но без нужного префикса
    if (href && href.endsWith('.html') && !href.startsWith('portfolio_pages/')) {
      link.setAttribute('href', 'portfolio_pages/' + href);
    }
  });
});
