;(() => {
  /** =========================
   *   1) СЛОВАРЬ (базовый)
   *  ========================= */
  const DICT = {
  en: (typeof window!=="undefined" && window.DICT_EN) || {
      /* index */
      "index.heading": "/ Choose your path!",
      "index.sub": "How to create an innovative startup in Italy",

      "filters.all": "All",
      "filters.law": "Law",
      "filters.idea": "Idea",
      "filters.business": "Business",
      "filters.investment": "Investment",

      "cards.innov.title": "Innovative Startup",
      "cards.innov.caption": "What it is and how it works",
      "cards.req.title": "Requirements",
      "cards.req.caption": "What your business has to comply with",
      "cards.idea.title": "Have an idea",
      "cards.idea.caption": "How to launch a startup and obtain a residence permit",
      "cards.havebiz.title": "Have a business",
      "cards.havebiz.caption": "How to turn it into a startup",
      "cards.buyidea.title": "Buy an idea",
      "cards.buyidea.caption": "How to acquire a ready-made concept",
      "cards.invest.title": "Investment",
      "cards.invest.caption": "How to obtain government funding",

      /* UI — дополнил */
      "ui.home": "Home",
      "ui.next": "Next",
      "ui.back": "Back",
      "ui.loading": "Loading...",
      "ui.checkreq": "Check requirements",
      "ui.understood": "Understood",
      "ui.createcompany": "Create a company",
      "ui.joinregister": "Join the register",
      "ui.skipcheck": "Skip the check",
      "ui.skipcheck.title": "Skip the check and learn how to register",
      "ui.yes": "Yes",
      "ui.alreadyhave": "I already have",
      "ui.howregister": "How to register?",
      "ui.documents": "Documents",
      "ui.lang.en": "EN",
      "ui.lang.ru": "RU",
      "ui.permesso": "permesso.me",
      "ui.whatsapp": "WhatsApp",
      "ui.facebook": "Facebook",
      "ui.instagram": "Instagram",
      "ui.currency": "€",

      /* META */
      "meta.title": "StartUp Innovativa. How to create an Innovative Startup in Italy and obtain a Residence Permit.",
      "meta.description": "",
      "meta.keywords": ""
    },
  ru: (typeof window!=="undefined" && window.DICT_RU) || {
      /* index */
      "index.heading": "/ Выберите свой путь!",
      "index.sub": "Как создать инновационный стартап в Италии",

      "filters.all": "Все",
      "filters.law": "Право",
      "filters.idea": "Идея",
      "filters.business": "Бизнес",
      "filters.investment": "Инвестиции",

      "cards.innov.title": "Инновационный стартап",
      "cards.innov.caption": "Что это и как работает",
      "cards.req.title": "Требования",
      "cards.req.caption": "Каким требованиям должен соответствовать бизнес",
      "cards.idea.title": "Есть идея",
      "cards.idea.caption": "Как запустить стартап и получить ВНЖ",
      "cards.havebiz.title": "Есть бизнес",
      "cards.havebiz.caption": "Как превратить его в стартап",
      "cards.buyidea.title": "Купить идею",
      "cards.buyidea.caption": "Как приобрести готовую концепцию",
      "cards.invest.title": "Инвестиции",
      "cards.invest.caption": "Как получить государственное финансирование",

      /* UI — дополнил */
      "ui.home": "Домой",
      "ui.next": "Дальше",
      "ui.back": "Назад",
      "ui.loading": "Загрузка…",
      "ui.checkreq": "Проверить требования",
      "ui.understood": "Понятно",
      "ui.createcompany": "Создать компанию",
      "ui.joinregister": "Вступить в реестр",
      "ui.skipcheck": "Пропустить проверку",
      "ui.skipcheck.title": "Пропустить проверку и перейти к регистрации",
      "ui.yes": "Да",
      "ui.alreadyhave": "Уже есть",
      "ui.howregister": "Как зарегистрировать?",
      "ui.documents": "Документы",
      "ui.lang.en": "EN",
      "ui.lang.ru": "RU",
      "ui.permesso": "permesso.me",
      "ui.whatsapp": "WhatsApp",
      "ui.facebook": "Facebook",
      "ui.instagram": "Instagram",
      "ui.currency": "€",

      /* META */
      "meta.title": "StartUp Innovativa. Как создать инновационный стартап в Италии и получить ВНЖ.",
      "meta.description": "",
      "meta.keywords": ""
    }
};

  /** =========================
   *   2) ГОТОВЫЕ ПЕРЕВОДЫ ДЛЯ H2/H3 (pre-set для автотега)
   *  ========================= */
  const PRESET = {
    // H2
    "Innovative Startup": "Инновационный стартап",
    "Legal Framework": "Правовая база",
    "Funding and Benefits": "Финансирование и льготы",
    "Company Registration": "Регистрация компании",
    "You're Ready!": "Готово!",
    "What requirements must your business meet to qualify as a Startup?": "Каким требованиям должен соответствовать ваш бизнес, чтобы считаться стартапом?",
    "Convert your business into a Startup.": "Преобразуйте свой бизнес в стартап.",
    "I want to buy a Startup idea!": "Хочу купить идею для стартапа!",
    "Investments for a Startup": "Инвестиции для стартапа",
    "How to obtain a residence permit through a Startup Innovativa?": "Как получить ВНЖ через StartUp Innovativa",
    "Residence permit through a Startup Innovativa": "ВНЖ через StartUp Innovativa",

    // H3
    "1.1 Law": "1.1 Закон",
    "1.3 Why it matters:": "1.3 Зачем это нужно:",
    "1.4 What are the main advantages?": "1.4 Главные преимущества",
    "1.5 Key advantages (continued)": "1.5 Преимущества (продолжение)",
    "1.6 Main advantages (continued)": "1.6 Преимущества (продолжение)",

    "2.1 Not older than 60 months": "2.1 Не старше 60 месяцев",
    "2.2 Tax residence": "2.2 Налоговое резидентство",
    "2.3 Turnover limits": "2.3 Ограничения по выручке",
    "2.4 Profits": "2.4 Прибыль",
    "2.5 Purpose": "2.5 Цель",
    "2.6 How was it established?": "2.6 Как была создана?",
    "2.7 Must meet at least one of the following:": "2.7 Должна соответствовать хотя бы одному пункту:",

    "3.1 Check": "3.1 Проверка",
    "3.2 Create": "3.2 Создание",
    "3.3 Legal form": "3.3 Правовая форма",
    "3.4 Register": "3.4 Регистрация",
    "3.5 Accounting": "3.5 Бухгалтерия",
    "3.6 Assistance": "3.6 Сопровождение",
    "3.7 Office rental": "3.7 Аренда офиса",
    "3.8 TOTAL": "3.8 ИТОГО",

    "4.1 Step 1": "4.1 Шаг 1",
    "4.2 Step 2": "4.2 Шаг 2",
    "4.3 Step 3": "4.3 Шаг 3",
    "4.4 Registration process": "4.4 Процедура регистрации",
    "4.5 Form": "4.5 Форма",
    "4.6 TOTAL": "4.6 ИТОГО",

    "5.1 Every idea is unique!": "5.1 Каждая идея уникальна!",
    "5.2 Identify": "5.2 Определиться",
    "5.3 Relevance": "5.3 Актуальность",
    "5.4 Framework": "5.4 Рамки",
    "5.5 Formalize": "5.5 Оформление",
    "5.6 TOTAL": "5.6 ИТОГО",

    "6.1 You already have a company in Italy": "6.1 У вас уже есть компания в Италии",
    "6.2 Your company is already listed in the Startup Register": "6.2 Ваша компания уже в реестре стартапов",
    "6.3 Prepare the documentation": "6.3 Подготовьте документы",
    "6.4 Perform an audit": "6.4 Проведите аудит",
    "6.5 Submit the application": "6.5 Подайте заявку",
    "6.6 Receive the subsidy": "6.6 Получите субсидию",
    "6.7 TOTAL": "6.7 ИТОГО",

    // доп. шаги
    "6.1 General procedure": "6.1 Общий порядок",
    "6.2 Financial requirements": "6.2 Финансовые требования",
    "6.3 Application process": "6.3 Подача заявки",
    "6.4 Obtaining a visa": "6.4 Получение визы",
    "6.5 After arrival": "6.5 После въезда",
    "6.6 Support programs": "6.6 Программы поддержки",
    "6.7 Summary": "6.7 Итоги"
  };

  /** =========================
   *   3) УТИЛИТЫ
   *  ========================= */
  const STORAGE_KEY = 'lang';
  const DEFAULT_LANG = 'en';
  const WARN_MISSING = true;

  const qsa = (sel, root = document) => Array.from(root.querySelectorAll(sel));

  function dict(lang) {
    return DICT[lang] || DICT[DEFAULT_LANG];
  }

  function ensureInDict(key, enValue, ruValue) {
    if (!DICT.en[key]) DICT.en[key] = enValue;
    if (!DICT.ru[key]) DICT.ru[key] = ruValue ?? PRESET[enValue] ?? enValue;
  }

  function setActive(lang) {
    qsa('.lang-btn').forEach(b => b.classList.toggle('active', b.dataset.lang === lang));
  }

  function logMissing(key, lang) {
    if (!WARN_MISSING) return;
    if (!logMissing._seen) logMissing._seen = new Set();
    const tag = `${lang}:${key}`;
    if (!logMissing._seen.has(tag)) {
      console.warn('[i18n] Missing key', lang, key);
      logMissing._seen.add(tag);
    }
  }

  /** =========================
   *   4) АВТО-РАЗМЕТКА КЛЮЧЕЙ (без правки HTML)
   *  ========================= */
  function autotagKeys() {
    // 4.1 Слайды: div[id^="slide"]
    qsa('div[id^="slide"]').forEach(sec => {
      const secId = sec.id;
      const h2 = sec.querySelector('h2:not([data-i18n])');
      if (h2 && !h2.querySelector('*')) {
        const key = `slides.${secId}.h2`;
        const txt = h2.textContent.trim();
        h2.setAttribute('data-i18n', key);
        ensureInDict(key, txt, PRESET[txt]);
      }
      const h3 = sec.querySelector('h3:not([data-i18n])');
      if (h3 && !h3.querySelector('*')) {
        const key = `slides.${secId}.h3`;
        const txt = h3.textContent.trim();
        h3.setAttribute('data-i18n', key);
        ensureInDict(key, txt, PRESET[txt]);
      }
    });

    // 4.2 Универсально: все h2/h3 без children и без data-i18n
    qsa('h2:not([data-i18n]), h3:not([data-i18n])').forEach(el => {
      if (el.querySelector('*')) return;
      const base = el.closest('div[id^="slide"]')?.id || 'page';
      const tag = el.tagName.toLowerCase();
      const key = `slides.${base}.${tag}`;
      const txt = el.textContent.trim();
      el.setAttribute('data-i18n', key);
      ensureInDict(key, txt, PRESET[txt]);
    });

    // 4.3 Кнопки/линки с общими фразами
    const uiMap = new Map([
      ['Home',        'ui.home'],
      ['Next',        'ui.next'],
      ['Back',        'ui.back'],
      ['Loading...',  'ui.loading'],
      ['Check requirements', 'ui.checkreq'],
      ['Understood',  'ui.understood'],
      ['Create a company', 'ui.createcompany'],
      ['Join the register', 'ui.joinregister'],
      ['Skip the check', 'ui.skipcheck'],
      ['Yes',         'ui.yes'],
      ['I already have', 'ui.alreadyhave'],
      ['How to register?', 'ui.howregister'],
      ['Documents',   'ui.documents'],
      ['EN',          'ui.lang.en'],
      ['RU',          'ui.lang.ru']
    ]);
    qsa('a, button').forEach(el => {
      if (el.hasAttribute('data-i18n')) return;
      const txt = (el.textContent || '').trim();
      if (!txt || txt.length > 60) return;
      const key = uiMap.get(txt);
      if (key) el.setAttribute('data-i18n', key);
    });

    // 4.4 Подсказки title для Skip the check
    qsa('button, a').forEach(el => {
      if (/(Skip the check)/i.test(el.textContent || '')) {
        el.setAttribute('data-i18n-attr','title');
        el.setAttribute('data-i18n','ui.skipcheck');
      }
    });

    // 4.5 META: <title> и <meta name="...">
    const titleEl = document.querySelector('head > title');
    if (titleEl && !titleEl.hasAttribute('data-i18n')) {
      titleEl.setAttribute('data-i18n','meta.title');
    }
    const metaDesc = document.querySelector('meta[name="description"]');
    if (metaDesc && !metaDesc.hasAttribute('data-i18n')) {
      metaDesc.setAttribute('data-i18n','meta.description');
      metaDesc.setAttribute('data-i18n-attr','content');
    }
    const metaKw = document.querySelector('meta[name="keywords"]');
    if (metaKw && !metaKw.hasAttribute('data-i18n')) {
      metaKw.setAttribute('data-i18n','meta.keywords');
      metaKw.setAttribute('data-i18n-attr','content');
    }
  }

  /** =========================
   *   5) ДОБОР КЛЮЧЕЙ ИЗ DOM (чтобы DICT не пустел)
   *  =========================
   * Пробегаемся по всем [data-i18n] и, если в DICT нет ключа — создаём его
   * из текущего текста/атрибутов (английская база), чтобы избежать "пустых" значений.
   */
  function harvestKeysIntoDict() {
    // Текстовые узлы
    qsa('[data-i18n]').forEach(el => {
      const key = el.getAttribute('data-i18n');
      if (!key) return;
      // если элемент управляет только атрибутами — текст может быть пустым
      const txt = (el.textContent || '').trim();
      if (!DICT.en[key] && txt) DICT.en[key] = txt;
      if (!DICT.ru[key] && txt) DICT.ru[key] = txt; // временный дубль, чтобы не затирать контент
    });

    // Атрибуты
    qsa('[data-i18n-attr]').forEach(el => {
      const base = el.getAttribute('data-i18n');
      if (!base) return;
      el.getAttribute('data-i18n-attr').split(':').map(s => s.trim()).forEach(attr => {
        const key = `${base}.${attr}`;
        const v = el.getAttribute(attr) || '';
        if (!DICT.en[key] && v) DICT.en[key] = v;
        if (!DICT.ru[key] && v) DICT.ru[key] = v;
      });
    });
  }

  /** =========================
   *   6) ПРИМЕНЕНИЕ ПЕРЕВОДА
   *  ========================= */
  function applyText(lang) {
    const d = dict(lang);

    // Текстовые узлы
    qsa('[data-i18n]').forEach(el => {
      const key = el.getAttribute('data-i18n');
      const val = d[key];
      if (val != null) {
        if (el.hasAttribute('data-i18n-html')) el.innerHTML = val;
        else el.textContent = val;
      } else {
        // если ключа нет — не затираем контент, просто предупреждаем
        logMissing(key, lang);
      }
    });

    // Атрибуты
    qsa('[data-i18n-attr]').forEach(el => {
      const base = el.getAttribute('data-i18n');
      el.getAttribute('data-i18n-attr').split(':').map(s=>s.trim()).forEach(attr=>{
        const key = `${base}.${attr}`;
        const v = d[key];
        if (v != null) el.setAttribute(attr, v);
        else logMissing(key, lang);
      });
    });
  }

  function setLang(lang) {
    autotagKeys();           // безопасная автоподметка
    harvestKeysIntoDict();   // добираем отсутствующие ключи из текущего DOM
    applyText(lang);         // применяем словарь
    setActive(lang);
    localStorage.setItem(STORAGE_KEY, lang);
  }

  /** =========================
   *   7) DEV-УТИЛИТЫ (по желанию)
   *  ========================= */
  // Выгрузить только "дыры" по выбранному языку (en/ru)
  window.i18nDumpMissing = function(lang = 'ru') {
    const d = dict(lang);
    const missing = {};
    qsa('[data-i18n]').forEach(el => {
      const key = el.getAttribute('data-i18n');
      if (!(key in d)) missing[key] = (el.textContent || '').trim();
    });
    qsa('[data-i18n-attr]').forEach(el => {
      const base = el.getAttribute('data-i18n');
      el.getAttribute('data-i18n-attr').split(':').map(s=>s.trim()).forEach(attr=>{
        const key = `${base}.${attr}`;
        if (!(key in d)) missing[key] = el.getAttribute(attr) || '';
      });
    });
    console.log('[i18n] Missing keys for', lang, missing);
    return missing;
  };

  /** =========================
   *   8) СЛУШАТЕЛИ
   *  ========================= */
  document.addEventListener('click', (e) => {
    const btn = e.target.closest('.lang-btn');
    if (btn) setLang(btn.dataset.lang);
  });

  document.addEventListener('DOMContentLoaded', () => {
    const saved = localStorage.getItem(STORAGE_KEY) || DEFAULT_LANG;
    setLang(saved);
  });
})();
